slovar_crk = {'a':1, 'b':2, 'c':3, 'd':4, 'e':5, 'f':6, 'g':7, 'h':8, 'i':9, 'j':10, 'k':11, 'l':12,
              'm':13,'n':14, 'o':15, 'p':16, 'r':17, 's':18, 't':19, 'u':20, 'v':21, 'z':22}

def vsota_crk(beseda):
    vsota = 0
    for crka in beseda:
        vsota += slovar_crk[crka]
    return vsota
# Se ena moznost:
# def vsota_crk2(beseda):
#     vsota = 0
#     for crka in beseda:
#         vsota += ord(crka) - 96
#     return vsota
# ord() vrne zaporedno stevilo znaka v ASCII tabeli. Vse male crke si sledijo po vrstnem redu, a je 96.

def produkt_crk(beseda):
    if len(beseda) == 0:
        return 0
    produkt = 1
    for crka in beseda:
        produkt *= slovar_crk[crka]
    return produkt

# Podobno kot zgoraj lahko definiramo se eno verzijo, ce uporabimo kar ord.

with open('besede.txt', 'r') as datoteka:
    seznam_besed = []
    for vrstica in datoteka:
        seznam_besed.append(vrstica[:-1])

# Sorted ureja stabilno: dva enakovredna elementa ohranita zacetni medsebojni vrstni red.
urejeni_seznam = sorted(seznam_besed, key = produkt_crk)
urejeni_seznam = sorted(urejeni_seznam, key = vsota_crk)

print("Rešitev: " + str(vsota_crk(urejeni_seznam[1742]) + vsota_crk(urejeni_seznam[882])))
# Ker sorted() ureja leksikografsko (najprej po prvih komponentah, potem drugih, tretjih, ...), lahko
# uredimo tudi tako:
# urejeni_seznam2 = sorted(seznam_besed, key = lambda beseda: (vsota_crk(beseda), produkt_crk(beseda)))


""" 
# Se ena mozna resitev, ki je mnogo daljsa, a ne uporablja opcije "key":

urejeni_seznam2 = []
# Upostevamo, da sort() ureja leksikografsko: najprej po prvih komponentah, potem drugih, tretjih, ...
for beseda in seznam_besed:
    urejeni_seznam2.append((vsota_crk(beseda), produkt_crk(beseda), beseda))
urejeni_seznam2.sort()

# Seznam je sedaj urejen, a ne povsem pravilno. Besede z enako vsoto in produktom so urejene po abecedi,
# ne pa po prvotnem razporedu. Da to popravimo, moramo poiskati vse take besede in jih ponovno raporediti
# po prvotnem vrstnem redu. Dva mozna pristopa:

# Prvi: cez prvotni seznam se zapeljemo le enkrat. Prvotni vrstni red besed shranimo v slovarju.
slovar_enakovrednih_besed = {}
for beseda in seznam_besed:
    kljuc = (vsota_crk(beseda), produkt_crk(beseda))
    if kljuc not in slovar_enakovrednih_besed:
        slovar_enakovrednih_besed[kljuc] = [beseda]
    else:
        slovar_enakovrednih_besed[kljuc].append(beseda)
        
# Sedaj se zapeljemo cez urejeni seznam. Ko naletimo na enakovredne besede, jih razporedimo po prvotnem
# vrstnem redu. Z dvema kazalcema se bomo sprehajali po seznamu. En kazalec se bo vedno premikal naprej,
# drug kazalec pa se bo ustavil, ko bomo naleteli na enakovredne besede. Tako bomo najdli celotno zaporedje
# enakovrednih besed (na kupu je lahko veliko enakovrednih besed). Istocasno lahko kar trojice
# (vsota, produkt, beseda) nadomestimo le z besedo. To bo najlazje storiti, ce nas program obravnava vsa
# zaporedja enakovrednih besed enako, tudi, ce je to zaporedje dolgo 1 (imamo le eno tako besedo).
# Najprej definiramo pomozno funkcijo, ki dano zaporedje enakovrednih besed uredi po vrsti in trojice
# nadomesti z besedami:

def popravi_seznam(kazalec1, kazalec2):
    beseda = urejeni_seznam2[kazalec1][2]
    kljuc = (vsota_crk(beseda), produkt_crk(beseda))
    for i in range(kazalec1, kazalec2):
        urejeni_seznam2[i] = slovar_enakovrednih_besed[kljuc][i - kazalec1]

kazalec1, kazalec2 = 0, 0 # kazalec2 bo vedno tekel naprej
for i in range(len(urejeni_seznam2) - 1):
    kazalec2 += 1
    if urejeni_seznam2[kazalec1][0:2] != urejeni_seznam2[kazalec2][0:2]:
        # Ce naletimo na neenakovredni besedi, smo nasli konec zaporedja. Poklicemo funkcijo popravi_seznam,
        # ki trojice nadomesti zgolj z besedami v pravem vrstnem redu.
        popravi_seznam(kazalec1, kazalec2)
        kazalec1 = kazalec2
# Funkcije popravi_seznam nismo se poklicali na zadnjem zaporedju:
popravi_seznam(kazalec1, kazalec2 + 1)


# Drugi mozni pristop, ki pa ga nisem implementiral: vsakic, ko naletimo na enakovredne besede v urejenem
# seznamu, se zapeljemo cez prvotni seznam in racunamo vsoto ter produkt besed. Besede s primerno vsoto
# in produktom povrsti dajemo v slovar na primerna mesta. Ta nacin je mnogo potratnejsi, ker se moramo
# ogromnokrat zapeljati cez seznam. A glede na dolzino seznama, bi tudi ta nacin moral iti skozi v kratkem
# casu.

with open ('urejene_besede.txt', 'w') as datoteka:
    prva_beseda = urejeni_seznam2[0]
    datoteka.write(prva_beseda)
    for beseda in urejeni_seznam2[1:]:
        datoteka.write('\n')
        datoteka.write(beseda)
"""

with open ('urejene_besede_resitve.txt', 'w') as datoteka:
    prva_beseda = urejeni_seznam[0]
    datoteka.write(prva_beseda) #+ ' ' + str(vsota_crk(prva_beseda)) + ' ' + str(produkt_crk(prva_beseda)))
    for beseda in urejeni_seznam[1:]:
        datoteka.write('\n')
        datoteka.write(beseda) #+ ' ' + str(vsota_crk(beseda)) + ' ' + str(produkt_crk(beseda)))